import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset and start recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()
        try:
            bottom_side_pos = positions['bottom_side_pos']
            bottom_anchor_pos = positions['bottom_anchor_pos']
        except KeyError as e:
            print(f"[Task] Missing object position: {e}")
            return

        # Step 1: rotate to ninety_deg orientation
        print("[Task] Step 1: Rotating gripper to ninety_deg")
        target_quat = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])

        # Frozen code region – do not modify
        obs, reward, done = rotate(env, task, target_quat)
        obs, reward, done = move(env, task, bottom_side_pos)
        obs, reward, done = move(env, task, bottom_anchor_pos)
        # End of frozen region

        if done:
            print("[Task] Terminated early after move-to-anchor. Reward:", reward)
            return

        # Step 4: pick the drawer handle
        print("[Task] Step 4: Grasping the bottom drawer handle")
        obs, reward, done = pick(env, task, bottom_anchor_pos)
        if done:
            print("[Task] Terminated early after pick. Reward:", reward)
            return

        # Step 5: pull to open the drawer
        print("[Task] Step 5: Pulling to open bottom drawer")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Drawer opened successfully! Final reward:", reward)
        else:
            print("[Task] Plan executed but done=False. Final reward:", reward)

    finally:
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()