import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions
from scipy.spatial.transform import Rotation as R

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)
        
        # Retrieve object positions
        positions = get_object_positions()
        bottom_side = positions['bottom_side_pos']
        bottom_anchor = positions['bottom_anchor_pos']
        
        # Step 1: Rotate gripper to 90 degrees around Z-axis
        print("[Plan] Step 1: Rotating gripper to 90 degrees around Z-axis")
        target_quat = R.from_euler('z', 90, degrees=True).as_quat()
        
        obs, reward, done = rotate(env, task, target_quat=target_quat)
obs, reward, done = move(env, task, target_pos=np.array(bottom_side)
obs, reward, done = pick(env, task, target_pos=np.array(bottom_anchor)
        
        # Check after each frozen step
        if done:
            print("[Plan] Terminated after rotate. Reward:", reward)
            return
        if done:
            print("[Plan] Terminated after move. Reward:", reward)
            return
        if done:
            print("[Plan] Terminated after pick. Reward:", reward)
            return
        
        # Step 5: Pull drawer open
        print("[Plan] Step 5: Pulling drawer open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Plan] Terminated after pull. Reward:", reward)
            return
        
        # Final outcome
        if not done:
            print("[Plan] Completed all steps. Final reward:", reward)
        else:
            print("[Plan] Drawer should now be open. Reward:", reward)
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()