import numpy as np
from scipy.spatial.transform import Rotation as R
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions from the environment
        positions = get_object_positions()

        # Ensure we have positions for the bottom drawer
        if 'bottom_side_pos' not in positions or 'bottom_anchor_pos' not in positions:
            print("[Task] Required positions for bottom drawer not found")
            return

        side_pos = np.array(positions['bottom_side_pos'])
        anchor_pos = np.array(positions['bottom_anchor_pos'])

        # Compute the target orientation: 90 degrees about Z axis
        target_quat = R.from_euler('z', 90, degrees=True).as_quat()

        # Execute the oracle plan step by step
        # 1) Rotate gripper to ninety_deg
        # 2) Move to side position of bottom drawer
        # 3) Move to anchor position of bottom drawer
        # === Frozen Code Start ===
    obs, reward, done = rotate(env, task, target_quat)
obs, reward, done = move(env, task, side_pos)
    obs, reward, done = move(env, task, anchor_pos)
        # === Frozen Code End ===

        # 4) Pick (grasp) the bottom drawer handle
        obs, reward, done = pick(env, task, anchor_pos)
        if done:
            print("[Task] Task ended early during pick")
            return

        # 5) Pull the drawer outward along the X axis
        obs, reward, done = pull(env, task, pull_distance=0.10, pull_axis='x')
        if done:
            print("[Task] Task ended early during pull")
            return

        print("[Task] Successfully opened 'bottom' drawer")

    except Exception as e:
        print(f"[Task] Exception occurred: {e}")
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()