import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan for "select a drawer and open it fully" ===
        # We choose the 'bottom' drawer since it's unlocked.
        drawer = 'bottom'

        # Step 1: Rotate gripper from zero_deg to ninety_deg (about Z axis)
        print("[Task] Step 1: Rotating gripper to 90° orientation...")
        # Quaternion for 90° about Z: [x, y, z, w] = [0, 0, sin(45°), cos(45°)]
        target_quat = np.array([0.0, 0.0, np.sin(np.pi / 4), np.cos(np.pi / 4)])
        [Frozen Code Start]
        obs, reward, done = rotate(env, task, target_quat=target_quat)
        obs, reward, done = move(env, task, target_pos=side_pos)
        obs, reward, done = move(env, task, target_pos=anchor_pos)
        obs, reward, done = pick(env, task, target_pos=anchor_pos)
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
        [Frozen Code End]
        if done:
            print("[Task] Task ended mid‐plan with done=True.")
            return

        # If pull succeeded without done, report success
        print("[Task] Drawer opened successfully! Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()