import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # We expect keys 'bottom_side_pos' and 'bottom_anchor_pos'
        bottom_side_pos = np.array(positions['bottom_side_pos'])
        bottom_anchor_pos = np.array(positions['bottom_anchor_pos'])

        # Parameters for plan
        pull_distance = 0.1  # meters
        # Quaternion for 90° about Z axis in xyzw format
        target_quat = np.array([0.0, 0.0, 0.7071, 0.7071])

        # === Execute Oracle Plan to Open Bottom Drawer ===
        obs, reward, done = rotate(env, task, target_quat)
        obs, reward, done = move(env, task, target_pos=bottom_side_pos)
        obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
        obs, reward, done = pick(env, task, target_pos=bottom_anchor_pos)
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')

        # Check final status
        if done:
            print(f"[Task] Task ended after pull step. Reward: {reward}")
        else:
            print(f"[Task] Plan executed; drawer should now be open. Reward: {reward}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()