import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()

        # Define orientation quaternions for zero and ninety degrees
        angle_quats = {
            'zero_deg': np.array([0.0, 0.0, 0.0, 1.0]),
            'ninety_deg': np.array([0.0, 0.0, 0.7071, 0.7071])
        }

        # === Oracle Plan Execution ===

        # Frozen Code Start
        obs, reward, done = rotate(env, task, angle_quats['ninety_deg'])
        obs, reward, done = move(env, task, positions['bottom_side_pos'])
        obs, reward, done = move(env, task, positions['bottom_anchor_pos'])
        obs, reward, done = pick(env, task, positions['bottom_anchor_pos'])
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        obs, reward, done = move(env, task, positions['middle_side_pos'])
        obs, reward, done = move(env, task, positions['middle_anchor_pos'])
        obs, reward, done = pick(env, task, positions['middle_anchor_pos'])
        # Frozen Code End

        if done:
            print("[Task] Execution ended during plan execution. Exiting.")
            return

        # Pull the middle drawer open
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Execution ended during second pull. Exiting.")
            return

        print("[Task] Goal achieved: pull open any drawer that is not locked.")

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()