    # Step 4: Pick (close gripper) at the anchor position to grasp the drawer handle
    print("[Task] Step 4: Picking bottom drawer handle")
    obs, reward, done = pick(env, task, target_pos=bottom_anchor_pos)
    if done:
        print("[Task] Episode ended after pick.")
        return

    # Step 5: Pull the drawer open along the X axis by a fixed distance
    pull_distance = 0.05
    print(f"[Task] Step 5: Pulling drawer by {pull_distance}m along X axis")
    obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
    if done:
        print("[Task] Episode ended after pull.")
        return

    # Final outcome
    if reward is not None and reward > 0:
        print("[Task] Task completed successfully! Final reward:", reward)
    else:
        print("[Task] Task finished but may not have fully succeeded. Reward:", reward)

finally:
    # Always ensure the environment is properly shutdown
    shutdown_environment(env)

print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()