# object_positions.py
import numpy as np
from pyrep.objects.dummy import Dummy
from pyrep.objects.joint import Joint

def get_drawer_positions():
    options = ['bottom', 'middle', 'top']
    positions = {}
    
    for opt in options:
        anchor = Dummy(f'waypoint_anchor_{opt}')
        anchor_pos = anchor.get_position()
        
        joint = Joint(f'drawer_joint_{opt}')
        joint_pos = joint.get_joint_position()
        
        side_offset = np.array([-0.30, 0, 0])
        side_pos = anchor_pos + side_offset + np.array([0, 0, 0.10])
        
        positions[opt] = {
            'anchor_pos': anchor_pos,
            'joint_pos': joint_pos,
            'side_pos': side_pos
        }
    
    waypoint1 = Dummy('waypoint1')
    waypoint1_pos = waypoint1.get_position()
    
    positions['waypoint1'] = waypoint1_pos
    return positions