        if done:
            print("[Task] Ended after rotation. Reward:", reward)
            return

        # Step 2: Move gripper to side position of bottom drawer
        print(f"[Task] Step 2: Move to side position of bottom drawer: {side_bottom_pos}")
        obs, reward, done = move(env, task, side_bottom_pos)
        if done:
            print("[Task] Ended after moving to side position. Reward:", reward)
            return

        # Step 3: Move gripper to anchor position of bottom drawer
        print(f"[Task] Step 3: Move to anchor position of bottom drawer: {anchor_bottom_pos}")
        obs, reward, done = move(env, task, anchor_bottom_pos)
        if done:
            print("[Task] Ended after moving to anchor position. Reward:", reward)
            return

        # Step 4: Pick the bottom drawer handle at the anchor position
        print("[Task] Step 4: Pick bottom drawer handle.")
        obs, reward, done = pick(env, task, anchor_bottom_pos)
        if done:
            print("[Task] Ended after pick. Reward:", reward)
            return

        # Step 5: Pull the bottom drawer out to open it (unlock the cabinet)
        print("[Task] Step 5: Pull bottom drawer (open).")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Drawer opened successfully. Reward:", reward)
        else:
            print("[Task] Completed all steps but done=False. Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()