import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Helper to map PDDL-style names to dictionary keys
        def key(name):
            return name.replace('-', '_')

        # === Oracle Plan Execution ===

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        zero_shape = Shape('zero_deg')
        ninety_shape = Shape('ninety_deg')
        target_quat = np.array(ninety_shape.get_quaternion())

        # Step 2: Move gripper to side position of the bottom drawer
        side_bottom = positions[key('side-pos-bottom')]

        # Step 3: Move gripper to anchor position of the bottom drawer
        anchor_bottom = positions[key('anchor-pos-bottom')]

        # === Frozen Code Start ===
        obs, reward, done = rotate(env, task, target_quat)
obs, reward, done = move(env, task, side_bottom)
obs, reward, done = move(env, task, anchor_bottom)
        # === Frozen Code End ===

        if done:
            print("[Plan] Terminated early after one of the initial actions.")
            return

        # Step 4: Pick (grasp) the bottom drawer handle
        obs, reward, done = pick(env, task, anchor_bottom)
        if done:
            print("[Plan] Ended after pick.")
            return

        # Step 5: Pull the drawer open
        obs, reward, done = pull(env, task, pull_distance=0.1)
        if done:
            print("[Plan] Ended after pull.")
            return

        print("===== Plan completed: Drawer opened successfully. =====")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()