[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Skeleton for running the drawer-opening task in simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Map PDDL drawer side and anchor positions for bottom drawer
        bottom_side_pos = np.array(positions['bottom_side_pos'])
        bottom_anchor_pos = np.array(positions['bottom_anchor_pos'])

        # Define quaternions for zero_deg and ninety_deg
        # zero_deg: identity orientation; ninety_deg: 90° about z-axis
        zero_deg_quat = np.array([0.0, 0.0, 0.0, 1.0])
        ninety_deg_quat = np.array([0.0, 0.0, 1.0, 0.0])

        # === Oracle Plan Execution ===

        # Step 1: rotate from zero_deg to ninety_deg
        print("[Task] Step 1: rotate to ninety_deg")
        obs, reward, done = rotate(env, task, ninety_deg_quat)
        if done:
            print("[Task] Terminated after step 1. Reward:", reward)
            return

        # Step 2: move to side position of bottom drawer
        print("[Task] Step 2: move to bottom side position")
        obs, reward, done = move(env, task, bottom_side_pos)
        if done:
            print("[Task] Terminated after step 2. Reward:", reward)
            return

        # Step 3: move to anchor position of bottom drawer
        print("[Task] Step 3: move to bottom anchor position")
        obs, reward, done = move(env, task, bottom_anchor_pos)
        if done:
            print("[Task] Terminated after step 3. Reward:", reward)
            return

        # Step 4: pick the bottom drawer at anchor position
        print("[Task] Step 4: pick bottom drawer")
        obs, reward, done = pick(env, task, bottom_anchor_pos)
        if done:
            print("[Task] Terminated after step 4. Reward:", reward)
            return

        # Step 5: pull bottom drawer open
        print("[Task] Step 5: pull bottom drawer open")
        # Use a small pull distance along x axis to open
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Terminated after step 5. Reward:", reward)
            return

        # Task completed successfully
        print("[Task] Completed all planned steps. Final reward:", reward)

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()
