# Continuing after the frozen code region

        if done:
            print("[Task] Task ended unexpectedly after rotate. Reward:", reward)
            return

        # Step 2: move gripper to bottom side position
        print("[Task] Step 2: move gripper to bottom side position")
        bottom_side_pos = positions.get('bottom_side_pos')
        if bottom_side_pos is None:
            raise KeyError("Position 'bottom_side_pos' not found in object positions.")
        obs, reward, done = move(env, task, target_pos=np.array(bottom_side_pos))
        if done:
            print("[Task] Task ended unexpectedly after moving to side position. Reward:", reward)
            return

        # Step 3: move gripper to bottom anchor position
        print("[Task] Step 3: move gripper to bottom anchor position")
        bottom_anchor_pos = positions.get('bottom_anchor_pos')
        if bottom_anchor_pos is None:
            raise KeyError("Position 'bottom_anchor_pos' not found in object positions.")
        obs, reward, done = move(env, task, target_pos=np.array(bottom_anchor_pos))
        if done:
            print("[Task] Task ended unexpectedly after moving to anchor position. Reward:", reward)
            return

        # Step 4: pick the bottom drawer at its anchor position
        print("[Task] Step 4: pick bottom drawer")
        obs, reward, done = pick(env, task, target_pos=np.array(bottom_anchor_pos))
        if done:
            print("[Task] Task ended unexpectedly during pick. Reward:", reward)
            return

        # Step 5: pull the bottom drawer to open it
        print("[Task] Step 5: pull bottom drawer to open cabinet")
        pull_distance = 0.1
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
        if done:
            print("[Task] Task ended after pull. Reward:", reward)
        else:
            print("[Task] Pull action completed. Current reward:", reward)

        # Final report
        print("[Task] Oracle plan execution complete. Final reward:", reward)

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
        raise
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()