import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        bottom_side_pos = positions.get('bottom_side_pos')
        bottom_anchor_pos = positions.get('bottom_anchor_pos')
        if bottom_side_pos is None or bottom_anchor_pos is None:
            raise KeyError("Missing bottom drawer positions in object_positions")

        # === Plan Execution ===
        # Step 1: Rotate gripper to 90 degrees orientation
        print("[Task] Step 1: Rotating gripper to 90 degrees orientation")
        target_quat = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])

        # Step 2: Prepare move targets (prints only; actions in frozen code)
        print("[Task] Step 2: Moving to bottom side position")
        print("[Task] Step 3: Moving to bottom anchor position")
[Frozen Code Start]
    obs, reward, done = rotate(env, task, target_quat)
obs, reward, done = move(env, task, bottom_side_pos)
    obs, reward, done = move(env, task, bottom_anchor_pos)
[Frozen Code End]
        if done:
            print("[Task] Early termination after move to anchor. Reward:", reward)
            return

        # Step 4: Pick the drawer handle at anchor position
        print("[Task] Step 4: Picking drawer at anchor position")
        obs, reward, done = pick(env, task, bottom_anchor_pos)
        if done:
            print("[Task] Early termination after pick. Reward:", reward)
            return

        # Step 5: Pulling drawer to open
        print("[Task] Step 5: Pulling drawer to open")
        pull_distance = 0.2
        obs, reward, done = pull(env, task, pull_distance, pull_axis='x')
        if done:
            print("[Task] Drawer opened successfully. Reward:", reward)
        else:
            print("[Task] Pull action finished without done flag. Reward:", reward)

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()