        # 5) Pull the drawer open along the approximate drawer axis
        print("[Task] Pulling the bottom drawer open.")
        vector = bottom_joint_pos - bottom_anchor_pos
        axis_idx = np.argmax(np.abs(vector))
        axis_map = {0: 'x', 1: 'y', 2: 'z'}
        pull_axis = axis_map[axis_idx] if vector[axis_idx] >= 0 else '-' + axis_map[axis_idx]
        pull_distance = float(np.linalg.norm(vector))
        obs, reward, done = pull(env, task, pull_distance, pull_axis=pull_axis, max_steps=100, threshold=0.01, timeout=10.0)
        if done:
            print("[Task] Finished early after pull.")
            return

        print("[Task] Successfully opened the bottom drawer.")
    except Exception as e:
        print(f"[Task] Exception encountered: {e}")
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()