[Frozen Code Start]
    
[Frozen Code End]

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers (optional)
        init_video_writers(obs)

        # Wrap the task methods for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        try:
            side_bottom_pos = positions['side-pos-bottom']
            anchor_bottom_pos = positions['anchor-pos-bottom']
            zero_quat = positions['zero_deg']
            ninety_quat = positions['ninety_deg']
        except KeyError as e:
            print(f"[Error] Missing object or orientation in positions: {e}")
            return

        # === Execute Oracle Plan ===
        # Step 1: Rotate gripper to ninety_deg
        print("[Task] Step 1: rotate to ninety_deg")
        obs, reward, done = rotate(env, task, target_quat=ninety_quat)
        if done:
            print("[Task] Terminated after rotate. Reward:", reward)
            return

        # Step 2: Move gripper to side-pos-bottom
        print("[Task] Step 2: move to side-pos-bottom at", side_bottom_pos)
        obs, reward, done = move(env, task, target_pos=side_bottom_pos)
        if done:
            print("[Task] Terminated after first move. Reward:", reward)
            return

        # Step 3: Move gripper to anchor-pos-bottom
        print("[Task] Step 3: move to anchor-pos-bottom at", anchor_bottom_pos)
        obs, reward, done = move(env, task, target_pos=anchor_bottom_pos)
        if done:
            print("[Task] Terminated after second move. Reward:", reward)
            return

        # Step 4: Pick the bottom drawer at anchor-pos-bottom
        print("[Task] Step 4: pick at anchor-pos-bottom")
        obs, reward, done = pick(env, task, target_pos=anchor_bottom_pos)
        if done:
            print("[Task] Terminated after pick. Reward:", reward)
            return

        # Step 5: Pull the drawer open
        print("[Task] Step 5: pull drawer to open")
        pull_distance = 0.1
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
        if done:
            print("[Task] Terminated after pull. Reward:", reward)
            return

        # Final check
        print("[Task] Completed all steps. Final reward:", reward)

    finally:
        # Ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()
