[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running the disposal task.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers (optional)
        init_video_writers(obs)

        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        try:
            rubbish_pos = positions['rubbish']
            bin_pos = positions['bin']
        except KeyError as e:
            print(f"Error: Could not find position for object {e}.")
            return

        # === Execute Oracle Plan ===

        # Step 1: pick up the rubbish
        print(f"[Task] Step 1: Picking up 'rubbish' at {rubbish_pos}")
        obs, reward, done = pick(
            env,
            task,
            target_pos=np.array(rubbish_pos),
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print(f"[Task] Ended during pick. Reward: {reward}")
            return

        # Step 2: place the rubbish into the bin
        print(f"[Task] Step 2: Placing 'rubbish' at {bin_pos}")
        obs, reward, done = place(
            env,
            task,
            target_pos=np.array(bin_pos),
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print(f"[Task] Completed successfully! Reward: {reward}")
        else:
            print(f"[Task] Finished plan but done=False. Reward: {reward}")

    finally:
        # Ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()
