import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Identify which object is trash (only this will be moved)
        trash_object = 'item3'
        if trash_object not in positions:
            raise KeyError(f"Trash object '{trash_object}' not found in positions.")
        trash_pos = positions[trash_object]
        
        # Get bin position
        bin_name = 'bin'
        if bin_name not in positions:
            raise KeyError(f"Bin '{bin_name}' not found in positions.")
        bin_pos = positions[bin_name]

        # === Execute Oracle Plan ===
        # Step 1: pick the trash object from its current location
        print(f"[Task] Step 1 - Picking up trash '{trash_object}' at position {trash_pos}")
[Frozen Code Start]
        obs, reward, done = pick(
            env,
            task,
            target_pos=trash_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
[Frozen Code End]
        if done:
            print("[Task] Task ended prematurely during pick. Reward:", reward)
            return

        # Step 2: place the trash into the bin
        print(f"[Task] Step 2 - Placing trash '{trash_object}' into bin at position {bin_pos}")
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Plan executed but done=False. Current reward:", reward)

    except Exception as e:
        print(f"[Task] Exception encountered: {e}")
        raise
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
