import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for recording (optional)
        init_video_writers(obs)

        # Wrap step and observation functions for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        item2_pos = positions['item2']
        bin_pos = positions['bin']

        # Step 1: Pick up the rubbish (item2) from the table
        print(f"[Task] Picking up rubbish (item2) at: {item2_pos}")
        [Frozen Code Start]
    obs, reward, done = pick(
            env,
            task,
            target_pos=item2_pos,
            approach_axis='z',
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            timeout=10.0
        )
obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos,
            approach_axis='z',
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            timeout=10.0
        )
    [Frozen Code End]
        if done:
            print(f"[Task] Task ended after pick. Reward: {reward}")
            return

        # Step 2: Place the rubbish into the trash can (bin)
        print(f"[Task] Placing rubbish into bin at: {bin_pos}")
        if done:
            print(f"[Task] Task completed successfully! Reward: {reward}")
        else:
            print(f"[Task] Task not completed yet. done={done}. Reward: {reward}")

    finally:
        # Always ensure environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()