[Frozen Code Start]
    
[Frozen Code End]

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Task Plan Execution ===
        try:
            # Ensure required objects are present
            if 'rubbish' not in positions or 'bin' not in positions:
                raise KeyError("Required object positions for 'rubbish' or 'bin' not found in environment.")

            # Step 1: Pick up the trash object 'rubbish' from its current location
            rubbish_pos = np.array(positions['rubbish'])
            print("[Task] Picking object 'rubbish' at:", rubbish_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=rubbish_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after pick step. Reward:", reward)
                return

            # Step 2: Place the trash object 'rubbish' into the 'bin'
            bin_pos = np.array(positions['bin'])
            print("[Task] Placing object 'rubbish' at:", bin_pos)
            obs, reward, done = place(
                env,
                task,
                target_pos=bin_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task completed successfully. Final reward:", reward)
            else:
                print("[Task] Task not completed yet (done=False).")
        except Exception as e:
            print(f"[Task] Exception occurred during execution: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()