def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'ball1' and 'ball2' in the positions dictionary
        ball1_pos = positions['ball1']
        ball2_pos = positions['ball2']
        robot_pos = positions['robot']

        # Step 1: Move to ball1's position
        print("[Task] Moving to ball1's position:", ball1_pos)
        obs, reward, done = move(env, robot_pos, ball1_pos)
        if done:
            print("[Task] Task ended after moving to ball1's position!")
            return

        # Step 2: Pick ball1
        print("[Task] Picking ball1 at:", ball1_pos)
        obs, reward, done = pick(env, task, target_pos=ball1_pos)
        if done:
            print("[Task] Task ended after picking ball1!")
            return

        # Step 3: Move to ball2's position
        print("[Task] Moving to ball2's position:", ball2_pos)
        obs, reward, done = move(env, ball1_pos, ball2_pos)
        if done:
            print("[Task] Task ended after moving to ball2's position!")
            return

        # Step 4: Place ball1 at ball2's position
        print("[Task] Placing ball1 at ball2's position:", ball2_pos)
        obs, reward, done = place(env, task, target_pos=ball2_pos)
        if done:
            print("[Task] Task ended after placing ball1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()