def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a rubbish object to pick
        rubbish_pos = positions['rubbish']  # Replace 'rubbish' with the actual object name
        robot_pos = positions['robot']  # Replace 'robot' with the actual robot name

        # Check if the rubbish is at the robot's location
        if not (rubbish_pos == robot_pos):
            print("[Task] Moving robot to rubbish location...")
            obs, reward, done = move(env, robot_pos, rubbish_pos)
            if done:
                print("[Task] Task ended after moving to rubbish location!")
                return

        # Attempt to pick the rubbish
        print("[Task] Attempting to pick up the rubbish...")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return

        # Assuming we have a drop location
        drop_location = positions['drop_zone']  # Replace 'drop_zone' with the actual drop location name

        # Move to drop location
        print("[Task] Moving robot to drop location...")
        obs, reward, done = move(env, rubbish_pos, drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Place the rubbish down
        print("[Task] Placing the rubbish down...")
        obs, reward, done = place(env, task, target_pos=drop_location)
        if done:
            print("[Task] Task ended after placing the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()