def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        item1_pos = positions['item1']  # Example object
        switch_pos = positions['switch']  # Example switch
        bin_pos = positions['bin']  # Example bin

        # Step 1: Move to item1's position
        print("[Task] Moving to item1's position:", item1_pos)
        obs, reward, done = move(env, 'room_a', 'room_a')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1 at:", item1_pos)
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to switch position
        print("[Task] Moving to switch position:", switch_pos)
        obs, reward, done = move(env, 'room_a', 'room_b')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to switch!")
            return

        # Step 4: Press the switch
        print("[Task] Pressing the switch at:", switch_pos)
        obs, reward, done = press(env, 'switch')  # Assuming press function is defined
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 5: Move to bin position
        print("[Task] Moving to bin position:", bin_pos)
        obs, reward, done = move(env, 'room_b', 'room_b')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to bin!")
            return

        # Step 6: Place item1 in the bin
        print("[Task] Placing item1 in the bin at:", bin_pos)
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after placing item1 in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()