def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']
        bin_pos = positions['bin']

        # Check if the object is in the plate before picking
        if not is_object_in_plate(env, task, tomato2_pos):
            print("Object not in plate. Cannot pick.")
            return

        # Approach and pick the object
        print("[Task] Manipulating tomato2 at:", tomato2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Move to the bin to drop the object
        print("[Task] Moving to bin at:", bin_pos)
        move(env, task, plate_pos, bin_pos)

        # Place the object in the bin
        print("[Task] Placing tomato2 in the bin.")
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos
        )
        
        if done:
            print("[Task] Task completed successfully!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()