def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        plate_pos = positions['plate']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']

        # Step 1: Move to the first tomato
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick the first tomato
        print("[Task] Picking tomato1")
        obs, reward, done = pick(env, task, 'tomato1', obs.robot_position)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 3: Move to the plate
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, task, obs.robot_position, plate_pos)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # Step 4: Place the first tomato on the plate
        print("[Task] Placing tomato1 on the plate")
        obs, reward, done = place(env, task, 'tomato1', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 5: Move to the second tomato
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 6: Pick the second tomato
        print("[Task] Picking tomato2")
        obs, reward, done = pick(env, task, 'tomato2', obs.robot_position)
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 7: Move to the plate again
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, task, obs.robot_position, plate_pos)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # Step 8: Place the second tomato on the plate
        print("[Task] Placing tomato2 on the plate")
        obs, reward, done = place(env, task, 'tomato2', plate_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()