def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a 'tomato' object to manipulate
        tomato_pos = positions.get('tomato')
        if tomato_pos is None:
            print("[Task] Tomato object not found in the environment.")
            return

        # Robot's initial position (assuming it's at the same location as the tomato)
        robot_initial_pos = positions.get('robot')
        if robot_initial_pos is None:
            print("[Task] Robot object not found in the environment.")
            return

        # Step 1: Move to the tomato's position
        print("[Task] Moving to the tomato's position:", tomato_pos)
        obs, reward, done = move(env, robot_initial_pos, tomato_pos)
        if done:
            print("[Task] Task ended after moving to the tomato!")
            return

        # Step 2: Pick the tomato
        print("[Task] Picking the tomato.")
        obs, reward, done = pick(env, 'tomato', 'room', 'gripper')
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 3: Move to the designated drop-off location (assuming it's 'drop_zone')
        drop_zone_pos = positions.get('drop_zone')
        if drop_zone_pos is None:
            print("[Task] Drop zone not found in the environment.")
            return

        print("[Task] Moving to the drop zone:", drop_zone_pos)
        obs, reward, done = move(env, tomato_pos, drop_zone_pos)
        if done:
            print("[Task] Task ended after moving to the drop zone!")
            return

        # Step 4: Place the tomato in the drop zone
        print("[Task] Placing the tomato in the drop zone.")
        obs, reward, done = place(env, task, drop_zone_pos)
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()