def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a switch and a robot in the environment
        robot_pos = positions['robot']
        switch_pos = positions['switch']
        object_pos = positions['object']  # e.g., a ball or any object to pick

        # Step 1: Move to the switch
        print("[Task] Moving to the switch at:", switch_pos)
        obs, reward, done = move(env, task, robot_pos, switch_pos)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 2: Close the gripper
        print("[Task] Closing the gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing the gripper!")
            return

        # Step 3: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 4: Move to the object
        print("[Task] Moving to the object at:", object_pos)
        obs, reward, done = move(env, task, switch_pos, object_pos)
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 5: Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, task, object_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 6: Move back to the switch
        print("[Task] Moving back to the switch.")
        obs, reward, done = move(env, task, object_pos, switch_pos)
        if done:
            print("[Task] Task ended after moving back to the switch!")
            return

        # Step 7: Place the object
        print("[Task] Placing the object.")
        obs, reward, done = place(env, task, object_pos)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()