def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'tomato1', 'tomato2', ..., 'plate'
        tomato_positions = [positions[f'tomato{i}'] for i in range(1, 4)]
        plate_position = positions['plate']

        # Step 1: Move to each tomato and pick them up
        for tomato_pos in tomato_positions:
            print(f"[Task] Moving to tomato at: {tomato_pos}")
            obs, reward, done = move(env, task, obs.robot_position, tomato_pos)
            if done:
                print("[Task] Task ended while moving to tomato!")
                return
            
            print(f"[Task] Picking up tomato at: {tomato_pos}")
            obs, reward, done = pick(env, task, 'tomato', tomato_pos, 'gripper')
            if done:
                print("[Task] Task ended while picking up tomato!")
                return

        # Step 2: Move to the plate and place the tomatoes
        print(f"[Task] Moving to plate at: {plate_position}")
        obs, reward, done = move(env, task, obs.robot_position, plate_position)
        if done:
            print("[Task] Task ended while moving to plate!")
            return
        
        for tomato_pos in tomato_positions:
            print(f"[Task] Placing tomato at: {plate_position}")
            obs, reward, done = place(env, task, 'tomato', plate_position)
            if done:
                print("[Task] Task ended while placing tomato!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()