def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'object_1' and 'object_2' in the environment
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']

        # Check if the objects are in the actual object list
        if 'object_1' not in positions or 'object_2' not in positions:
            print("Error: One or more objects are not in the environment.")
            return

        # Step 1: Move to the location of object_1
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, 'room_a', 'room_b')  # Example rooms, replace with actual room names
        if done:
            print("[Task] Task ended after moving to object_1 location!")
            return

        # Step 2: Pick object_1
        print("[Task] Picking object_1...")
        obs, reward, done = pick(env, task, target_pos=object_1_pos)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to the location of object_2
        print("[Task] Moving to object_2 at:", object_2_pos)
        obs, reward, done = move(env, 'room_b', 'room_c')  # Example rooms, replace with actual room names
        if done:
            print("[Task] Task ended after moving to object_2 location!")
            return

        # Step 4: Place object_1 at object_2's location
        print("[Task] Placing object_1 at object_2's location...")
        obs, reward, done = place(env, task, target_pos=object_2_pos)
        if done:
            print("[Task] Task ended after placing object_1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()