def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'item1' to pick and a location 'room1' to place it
        item1_pos = positions['item1']
        room1_pos = positions['room1']

        # Step 1: Move to the location of item1
        print("[Task] Moving to item1 at:", item1_pos)
        obs, reward, done = move(env, task, obs.robot_position, item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1...")
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to room1 to place item1
        print("[Task] Moving to room1 at:", room1_pos)
        obs, reward, done = move(env, task, obs.robot_position, room1_pos)
        if done:
            print("[Task] Task ended after moving to room1!")
            return

        # Step 4: Place item1 in room1
        print("[Task] Placing item1 in room1...")
        obs, reward, done = place(env, task, target_pos=room1_pos)
        if done:
            print("[Task] Task ended after placing item1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()