def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a plate and tomatoes in the environment
        plate_pos = positions['plate']
        tomato_pos = positions['tomato']

        # Step 1: Move to the tomato
        print("[Task] Moving to the tomato at:", tomato_pos)
        obs, reward, done = move(env, task, from_room='table', to_room='tomato_location')
        if done:
            print("[Task] Task ended after moving to the tomato!")
            return

        # Step 2: Pick the tomato
        print("[Task] Picking the tomato.")
        obs, reward, done = pick(env, task, obj='tomato', room='tomato_location')
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 3: Move to the plate
        print("[Task] Moving to the plate at:", plate_pos)
        obs, reward, done = move(env, task, from_room='tomato_location', to_room='plate_location')
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        # Step 4: Place the tomato on the plate
        print("[Task] Placing the tomato on the plate.")
        obs, reward, done = place(env, task, obj='tomato', room='plate_location')
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()