def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named as follows based on the provided context
        ball = 'item1'
        switch = 'switch'
        bin = 'bin'
        room = 'room'

        # Step 1: Move to the room where the ball is located
        print("[Task] Moving to the room to pick up the ball.")
        obs, reward, done = move(env, task, from_room='initial_room', to_room=room)
        if done:
            print("[Task] Task ended after moving to the room!")
            return

        # Step 2: Pick up the ball
        print("[Task] Picking up the ball.")
        obs, reward, done = pick(env, ball, room, gripper='right')
        if done:
            print("[Task] Task ended after picking up the ball!")
            return

        # Step 3: Move to the switch to turn on the light
        print("[Task] Moving to the switch to turn on the light.")
        obs, reward, done = move(env, task, from_room=room, to_room='switch_room')
        if done:
            print("[Task] Task ended after moving to the switch room!")
            return

        # Step 4: Close the gripper to ensure the ball is held
        print("[Task] Closing the gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing the gripper!")
            return

        # Step 5: Press the switch to turn on the light
        print("[Task] Pressing the switch to turn on the light.")
        obs, reward, done = press(env, switch)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 6: Move to the bin to dispose of the ball
        print("[Task] Moving to the bin to dispose of the ball.")
        obs, reward, done = move(env, task, from_room='switch_room', to_room='bin_room')
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 7: Place the ball in the bin
        print("[Task] Placing the ball in the bin.")
        obs, reward, done = place(env, ball, 'bin_room')
        if done:
            print("[Task] Task ended after placing the ball in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()