def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        object_1_pos = positions['tomato2']  # Assuming 'tomato2' is the object we want to manipulate
        switch_pos = positions['switch']      # Position of the switch
        bin_pos = positions['bin']            # Position of the bin

        # Step 1: Move to the object (tomato2)
        print("[Task] Moving to tomato2 at:", object_1_pos)
        obs, reward, done = move(env, task, 'current_room', 'room_with_tomato2')
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 2: Pick up the object (tomato2)
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, task, 'tomato2', 'room_with_tomato2')
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # Step 3: Move to the switch
        print("[Task] Moving to the switch at:", switch_pos)
        obs, reward, done = move(env, task, 'room_with_tomato2', 'room_with_switch')
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Step 4: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 5: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, task, 'room_with_switch', 'room_with_bin')
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 6: Place the object (tomato2) in the bin
        print("[Task] Placing tomato2 in the bin.")
        obs, reward, done = place(env, task, 'tomato2', 'room_with_bin')
        if done:
            print("[Task] Task ended after placing tomato2 in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()