def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a room and an object to manipulate
        room = 'room1'  # Example room
        object_name = 'object1'  # Example object
        object_pos = positions[object_name]

        # Step 1: Move to the object's location
        print(f"[Task] Moving to {object_name} at {object_pos}.")
        obs, reward, done = move(env, room, object_pos)
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 2: Pick the object
        print(f"[Task] Picking up {object_name}.")
        obs, reward, done = pick(env, task, target_pos=object_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to a different location to place the object
        new_location = 'room2'  # Example new location
        print(f"[Task] Moving to {new_location} to place the object.")
        obs, reward, done = move(env, object_pos, new_location)
        if done:
            print("[Task] Task ended after moving to the new location!")
            return

        # Step 4: Place the object
        print(f"[Task] Placing {object_name} at {new_location}.")
        obs, reward, done = place(env, task, target_pos=new_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()