def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we are looking for a specific object, e.g., 'tomato'
        target_name = 'tomato'
        if target_name not in [obj['name'] for obj in positions]:
            print(f"Target object '{target_name}' not found in environment.")
            return

        target_pos = positions[target_name]

        # Move to the object's location
        print(f"[Task] Moving to the location of {target_name} at:", target_pos)
        obs, reward, done = move(env, task, obs.robot_position, target_pos)
        if done:
            print("[Task] Task ended after moving to the object location!")
            return

        # Attempt to pick the object
        print(f"[Task] Attempting to pick {target_name}...")
        obs, reward, done = pick(env, task, target_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Assuming we need to place the object somewhere, e.g., 'drop_zone'
        drop_zone = positions['drop_zone']  # Ensure 'drop_zone' is defined in your positions
        print(f"[Task] Moving to drop zone at:", drop_zone)
        obs, reward, done = move(env, task, obs.robot_position, drop_zone)
        if done:
            print("[Task] Task ended after moving to drop zone!")
            return

        # Place the object in the drop zone
        print(f"[Task] Attempting to place {target_name} in the drop zone...")
        obs, reward, done = place(env, task, target_name, drop_zone)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()