def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'rubbish' and 'switch'
        rubbish_pos = positions['rubbish']
        switch_pos = positions['switch']

        # Step 1: Move to the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, from_room='rooma', to_room='roomb')
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', 'roomb', 'gripper')
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Move to the switch
        print("[Task] Moving to switch at:", switch_pos)
        obs, reward, done = move(env, task, from_room='roomb', to_room='roomc')
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Step 4: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, target_pos=switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 5: Place the rubbish down
        print("[Task] Placing down the rubbish.")
        obs, reward, done = place(env, 'rubbish', 'roomc')
        if done:
            print("[Task] Task ended after placing down the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()