def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'tomato2' in the environment
        tomato2_pos = positions['tomato2']  # Replace with actual object name

        # Step 1: Move to the location of the object
        print("[Task] Moving to the location of tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, from_room='rooma', to_room='roomb')  # Adjust room names as necessary
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 2: Pick up the object
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, task, obj='tomato2', room='roomb', gripper='gripper')  # Adjust parameters as necessary
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # Step 3: Move to a new location to place the object
        new_location = 'roomc'  # Define the new location
        print("[Task] Moving to the new location:", new_location)
        obs, reward, done = move(env, task, from_room='roomb', to_room=new_location)
        if done:
            print("[Task] Task ended after moving to the new location!")
            return

        # Step 4: Place the object down
        print("[Task] Placing down tomato2.")
        obs, reward, done = place(env, task, obj='tomato2', room=new_location)
        if done:
            print("[Task] Task ended after placing down tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()