def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'object_1' to pick and place
        object_1_pos = positions['object_1']
        room_location = 'room_a'  # Example room location

        # Check if the object is present before attempting to pick
        if 'object_1' in positions:
            print("[Task] Manipulating object_1 at:", object_1_pos)

            # Move to the object's location
            obs, reward, done = move(env, task, 'room_a', 'room_a')  # Assuming the robot starts in room_a
            if done:
                print("[Task] Task ended during movement!")
                return

            # Pick the object
            obs, reward, done = pick(env, task, object_1_pos)
            if done:
                print("[Task] Task ended after picking object_1!")
                return

            # Move to the drop location (e.g., another room)
            obs, reward, done = move(env, task, 'room_a', 'room_b')  # Move to room_b
            if done:
                print("[Task] Task ended during movement!")
                return

            # Place the object
            obs, reward, done = place(env, task, object_1_pos)
            if done:
                print("[Task] Task ended after placing object_1!")
                return

        else:
            print("[Task] object_1 not found in the environment!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()