def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object to pick and a location to place it
        object_to_pick = 'object_1'  # Replace with actual object name
        object_to_place = 'object_2'  # Replace with actual object name
        current_location = 'room_a'    # Replace with actual room name

        # Check if the object is in the positions
        if object_to_pick in positions:
            object_pos = positions[object_to_pick]
            print(f"[Task] Manipulating {object_to_pick} at:", object_pos)

            # Move to the object's location
            obs, reward, done = move(env, current_location, object_pos)
            if done:
                print("[Task] Task ended after moving to the object location!")
                return

            # Attempt to pick the object
            obs, reward, done = pick(env, object_to_pick, current_location, 'gripper')
            if done:
                print("[Task] Task ended after picking the object!")
                return

            # Now move to the place location
            place_location = 'room_b'  # Replace with actual room name
            obs, reward, done = move(env, current_location, place_location)
            if done:
                print("[Task] Task ended after moving to the place location!")
                return

            # Attempt to place the object
            obs, reward, done = place(env, object_to_pick, place_location)
            if done:
                print("[Task] Task ended after placing the object!")
                return
        else:
            print(f"Object {object_to_pick} not found in object positions.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()