def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named as follows based on the feedback
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']
        table_pos = positions['table']
        bin_pos = positions['bin']
        plate_pos = positions['plate']
        switch_pos = positions['switch']

        # Step 1: Move to the table to pick up the first tomato
        print("[Task] Moving to the table to pick up tomato1.")
        obs, reward, done = move(env, task, current_pos, table_pos)
        if done:
            print("[Task] Task ended after moving to the table!")
            return

        # Step 2: Pick up tomato1
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, task, 'tomato1', table_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 3: Move to the bin to drop the rubbish
        print("[Task] Moving to the bin to drop rubbish.")
        obs, reward, done = move(env, task, current_pos, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 4: Drop the rubbish
        print("[Task] Dropping the rubbish.")
        obs, reward, done = place(env, task, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended after dropping the rubbish!")
            return

        # Step 5: Move to the switch to press it
        print("[Task] Moving to the switch to press it.")
        obs, reward, done = move(env, task, current_pos, switch_pos)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 6: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()