def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'tomato1' and a plate
        tomato1_pos = positions['tomato1']
        plate_pos = positions['plate']

        # Step 1: Move to the tomato's position
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, from_room='room1', to_room='room2')  # Adjust room names as necessary
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick up the tomato
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', 'room2', 'gripper')  # Adjust parameters as necessary
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 3: Move to the plate's position
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, task, from_room='room2', to_room='room3')  # Adjust room names as necessary
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # Step 4: Place the tomato on the plate
        print("[Task] Placing tomato1 on the plate.")
        obs, reward, done = place(env, 'tomato1', 'room3')  # Adjust parameters as necessary
        if done:
            print("[Task] Task ended after placing tomato1 on the plate!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()