def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object to pick and a location to place it
        object_to_pick = 'object_1'  # Replace with actual object name
        object_to_place = 'object_2'  # Replace with actual object name
        pick_location = positions[object_to_pick]
        place_location = positions[object_to_place]

        # Step 1: Move to the pick location
        print(f"[Task] Moving to pick location: {pick_location}")
        obs, reward, done = move(env, task, obs.robot_position, pick_location)
        if done:
            print("[Task] Task ended after moving to pick location!")
            return

        # Step 2: Pick the object
        print(f"[Task] Picking object: {object_to_pick}")
        obs, reward, done = pick(env, task, object_to_pick, pick_location)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the place location
        print(f"[Task] Moving to place location: {place_location}")
        obs, reward, done = move(env, task, obs.robot_position, place_location)
        if done:
            print("[Task] Task ended after moving to place location!")
            return

        # Step 4: Place the object
        print(f"[Task] Placing object: {object_to_pick}")
        obs, reward, done = place(env, task, object_to_pick, place_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()