def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'item1' to manipulate
        item1_pos = positions['item1']
        robot_pos = positions['robot']

        # Step 1: Move to the object's location
        print("[Task] Moving to item1 at:", item1_pos)
        obs, reward, done = move(env, task, robot_pos, item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick up the object
        print("[Task] Picking up item1.")
        obs, reward, done = pick(env, task, 'item1', item1_pos)
        if done:
            print("[Task] Task ended after picking up item1!")
            return

        # Step 3: Move to a new location to place the object
        new_location = positions['new_location']  # Assuming a new location is defined
        print("[Task] Moving to new location:", new_location)
        obs, reward, done = move(env, task, item1_pos, new_location)
        if done:
            print("[Task] Task ended after moving to new location!")
            return

        # Step 4: Place the object down
        print("[Task] Placing item1 at new location.")
        obs, reward, done = place(env, task, 'item1', new_location)
        if done:
            print("[Task] Task ended after placing item1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()