def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object to manipulate
        target_object = 'object_1'  # Replace with actual object name
        target_pos = positions[target_object]

        # Step 1: Move to the object's location
        print(f"[Task] Moving to {target_object} at:", target_pos)
        obs, reward, done = move(env, task, from_room='room_a', to_room='room_b')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 2: Pick the object
        print(f"[Task] Picking up {target_object}.")
        obs, reward, done = pick(env, target_object, 'room_b', 'gripper')  # Replace 'room_b' with actual room
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the desired drop location
        drop_location = 'room_c'  # Replace with actual drop location
        print(f"[Task] Moving to drop location: {drop_location}.")
        obs, reward, done = move(env, task, from_room='room_b', to_room=drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 4: Place the object down
        print(f"[Task] Placing down {target_object}.")
        obs, reward, done = place(env, target_object, drop_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()