def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        plate_pos = positions['plate']
        tomato_pos = positions['tomato']
        
        # Step 1: Move to the plate
        print("[Task] Moving to the plate at:", plate_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        # Step 2: Check if the tomato is on the plate
        if obs.at['tomato'] == plate_pos:
            print("[Task] Tomato is on the plate, proceeding to pick it up.")
            # Step 3: Pick up the tomato
            obs, reward, done = pick(env, task, obj='tomato', loc=plate_pos)
            if done:
                print("[Task] Task ended after picking up the tomato!")
                return

            # Step 4: Move to a new location to place the tomato
            new_location = positions['new_location']
            print("[Task] Moving to the new location at:", new_location)
            obs, reward, done = move(env, task, from_room=plate_pos, to_room=new_location)
            if done:
                print("[Task] Task ended after moving to the new location!")
                return

            # Step 5: Place the tomato at the new location
            print("[Task] Placing the tomato at the new location.")
            obs, reward, done = place(env, task, obj='tomato', loc=new_location)
            if done:
                print("[Task] Task ended after placing the tomato!")
                return
        else:
            print("[Task] Tomato is not on the plate, cannot proceed to pick it up.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()