def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a 'button' to press and a 'robot' to control
        button_pos = positions['button']  # Replace with actual object name
        robot_pos = positions['robot']  # Replace with actual robot name

        # Move to the button's position
        print("[Task] Moving to button position:", button_pos)
        obs, reward, done = move(env, task, robot_pos, button_pos)
        if done:
            print("[Task] Task ended after moving to button!")
            return

        # Close the gripper to prepare for pressing
        print("[Task] Closing gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Press the button
        print("[Task] Pressing the button.")
        obs, reward, done = press(env, task, button_pos)
        if done:
            print("[Task] Task ended after pressing the button!")
            return

        # Optionally, you can add more steps here if needed

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()