def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object to manipulate
        target_object = 'tomato1'  # Example target object
        target_pos = positions.get(target_object)

        if target_pos is None:
            print(f"[run_skeleton_task] Target object '{target_object}' not found in object positions. Aborting.")
            return

        # Check if the robot is at the initial position
        robot_initial_pos = positions.get('robot')
        if robot_initial_pos is None:
            print("[run_skeleton_task] Robot initial position not found. Aborting.")
            return

        # Move to the target object's location
        print(f"[Task] Moving to {target_object} at position: {target_pos}")
        obs, reward, done = move(env, robot_initial_pos, target_pos)
        if done:
            print("[Task] Task ended after moving to target position!")
            return

        # Attempt to pick the target object
        print(f"[Task] Attempting to pick {target_object} at position: {target_pos}")
        obs, reward, done = pick(env, task, target_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Assuming we need to place the object somewhere after picking
        drop_location = positions.get('drop_zone')  # Example drop zone
        if drop_location is None:
            print("[run_skeleton_task] Drop zone not found. Aborting.")
            return

        # Place the object in the drop zone
        print(f"[Task] Placing {target_object} at drop zone: {drop_location}")
        obs, reward, done = place(env, task, drop_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()