def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a robot and a location to move to
        robot_position = positions['robot']
        object_position = positions['object']  # Replace 'object' with actual object key

        # Step 1: Move to the object's location
        print("[Task] Moving to object at:", object_position)
        obs, reward, done = move(env, robot_position, object_position)
        if done:
            print("[Task] Task ended after moving to object!")
            return

        # Step 2: Pick the object
        print("[Task] Picking the object at:", object_position)
        obs, reward, done = pick(env, 'object', object_position, 'gripper')  # Replace 'object' with actual object key
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to a new location to place the object
        new_location = positions['new_location']  # Replace with actual new location key
        print("[Task] Moving to new location at:", new_location)
        obs, reward, done = move(env, object_position, new_location)
        if done:
            print("[Task] Task ended after moving to new location!")
            return

        # Step 4: Place the object
        print("[Task] Placing the object at:", new_location)
        obs, reward, done = place(env, 'object', new_location)  # Replace 'object' with actual object key
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()