def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'item1' in the environment
        item1_pos = positions['item1']
        room_pos = positions['room']

        # Step 1: Move to the room where item1 is located
        print("[Task] Moving to the room to pick up item1.")
        obs, reward, done = move(env, task, 'current_room', room_pos)
        if done:
            print("[Task] Task ended after moving to the room!")
            return

        # Step 2: Pick up item1
        print("[Task] Picking up item1 at:", item1_pos)
        obs, reward, done = pick(env, task, 'item1', room_pos)
        if done:
            print("[Task] Task ended after picking up item1!")
            return

        # Step 3: Move to the disposal location
        disposal_pos = positions['disposal']
        print("[Task] Moving to the disposal location.")
        obs, reward, done = move(env, task, room_pos, disposal_pos)
        if done:
            print("[Task] Task ended after moving to the disposal location!")
            return

        # Step 4: Place item1 in the disposal location
        print("[Task] Placing item1 at the disposal location.")
        obs, reward, done = place(env, task, 'item1', disposal_pos)
        if done:
            print("[Task] Task ended after placing item1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()