def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'object_1' to pick
        object_1_pos = positions['object_1']  # Replace with actual object name
        print("[Task] Manipulating object_1 at:", object_1_pos)

        # Check if the object is in the object list
        if 'object_1' not in positions:
            print("Error: Object not found in object list.")
            return

        # Step 1: Move to the object's position
        obs, reward, done = move(env, 'room_a', 'room_b')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to the object's position!")
            return

        # Step 2: Pick the object
        obs, reward, done = pick(env, task, target_pos=object_1_pos)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to the target location to place the object
        target_location = positions['target_location']  # Replace with actual target location
        obs, reward, done = move(env, 'room_b', 'room_c')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to the target location!")
            return

        # Step 4: Place the object
        obs, reward, done = place(env, task, target_pos=target_location)
        if done:
            print("[Task] Task ended after placing object_1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()