def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a specific object to manipulate, e.g., 'tomato2'
        target_object = 'tomato2'
        target_pos = positions.get(target_object)

        if target_pos is None:
            print(f"[Task] Error: {target_object} not found in the environment.")
            return

        # Step 1: Move to the object's location
        print(f"[Task] Moving to {target_object} at position: {target_pos}")
        obs, reward, done = move(env, task, obs.robot_position, target_pos)

        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 2: Pick the object
        print(f"[Task] Attempting to pick {target_object}.")
        obs, reward, done = pick(env, task, target_pos)

        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to a designated drop-off location (assuming it's defined)
        drop_off_location = positions.get('drop_zone')  # Example drop-off location
        if drop_off_location is None:
            print("[Task] Error: Drop-off location not found.")
            return

        print(f"[Task] Moving to drop-off location: {drop_off_location}")
        obs, reward, done = move(env, task, target_pos, drop_off_location)

        if done:
            print("[Task] Task ended after moving to drop-off location!")
            return

        # Step 4: Place the object down
        print(f"[Task] Attempting to place {target_object} at drop-off location.")
        obs, reward, done = place(env, task, target_object, drop_off_location)

        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()